@echo off
 
REM Verzeichnisse
set toolsdir=C:\Draeger\tools\
set backupdir=C:\Draeger\Backup
 
REM maximales Alter fuer Backups
set alter_tagesbackups=-7
set alter_wochenbackups=-31
set alter_monatsbackups=-124
 
REM Backuptag fuer Wochenbackup
set backuptag=Sonntag
 
REM Datumsformatierung
for /f "tokens=1,2*" %%a in ('date /t') do set date=%%b
set datum=%date:~6,4%-%date:~3,2%-%date:~0,2%
set monat=%date:~3,2%
set jahr=%date:~6,4%
 
REM Wochentag als Zahl
for /F "skip=2 tokens=2-4 delims=," %%A in ('WMIC Path Win32_LocalTime Get DayOfWeek /Format:csv') do set tagnummer=%%A 
 
REM Wochentag ausgeschrieben
set daysofweek=Montag,Dienstag,Mittwoch,Donnerstag,Freitag,Samstag,Sonntag
for /F "tokens=%tagnummer% delims=," %%B in ("%daysofweek%") do set tag=%%B
 
echo Tagesbackup erstellen...
 
%toolsdir%\drw2gbk.exe /A /D%backupdir%\ /F%date%-draegerware-tagesbackup.fbkx
forfiles /P %backupdir%\ /S /M *-tagesbackup.fbkx /D %alter_tagesbackups% /C "cmd /c del /Q @path"
 
IF %tag% == %backuptag% (
    echo Wochenbackup erstellen...
    copy /Y %backupdir%\%date%-draegerware-tagesbackup.fbkx %backupdir%\%date%-draegerware-wochenbackup.fbkx
    forfiles /P %backupdir%\ /S /M *-wochenbackup.fbkx /D %alter_wochenbackups% /C "cmd /c del /Q @path"
)
 
IF %date% == 01.%monat%.%jahr% (
    echo Monatsbackup erstellen...
    copy /Y %backupdir%\%date%-draegerware-tagesbackup.fbkx %backupdir%\%jahr%-%monat%-draegerware-monatsbackup.fbkx
    forfiles /P %backupdir%\ /S /M *-monatsbackup.fbkx /D %alter_monatsbackups% /C "cmd /c del /Q @path"
)
 
IF %date% == 01.01.%jahr% (
    echo Jahresbackup erstellen...
    copy /Y %backupdir%\%date%-draegerware-tagesbackup.fbkx %backupdir%\%jahr%-draegerware-jahresbackup.fbkx
)
 
@echo on
