@echo off
chcp 1252 >nul
setlocal enableextensions

REM ==== EINSTELLUNGEN ====
set "toolsdir=C:\Draeger\tools"
set "backupdir=C:\Draeger\Backup"
set "logdir=C:\Draeger\Backup\Logs"

set "alter_tagesbackups=-7"
set "alter_wochenbackups=-31"
set "alter_monatsbackups=-124"
set "backuptag=Sonntag"

REM ==== LOGVERZEICHNIS ANLEGEN ====
if not exist "%logdir%" (
    mkdir "%logdir%"
    if errorlevel 1 (
        echo [FEHLER] Logverzeichnis konnte nicht erstellt werden: %logdir%
        goto :error
    )
)

REM ==== MODERNISIERTE DATUMSERMITTUNG ====
for /f %%a in ('powershell -NoProfile -Command "Get-Date -Format yyyy"') do set "jahr=%%a"
for /f %%a in ('powershell -NoProfile -Command "Get-Date -Format MM"') do set "monat=%%a"
for /f %%a in ('powershell -NoProfile -Command "Get-Date -Format dd"') do set "tag_des_monats=%%a"
for /f %%a in ('powershell -NoProfile -Command "Get-Date -Format dddd"') do set "wochentag=%%a"

set "datum=%jahr%-%monat%-%tag_des_monats%"
set "logfile=%logdir%\%datum%-backup.log"

REM ==== EXISTENZPRFUNGEN ====
call :log "Starte Backup-Skript"
if not exist "%toolsdir%\drw2gbk.exe" (
    echo [FEHLER] Backup-Tool drw2gbk.exe nicht gefunden unter %toolsdir%.
    call :log "[FEHLER] Backup-Tool drw2gbk.exe nicht gefunden unter %toolsdir%."
    goto :error
)
if not exist "%backupdir%" (
    echo [FEHLER] Backupverzeichnis %backupdir% existiert nicht.
    call :log "[FEHLER] Backupverzeichnis %backupdir% existiert nicht."
    goto :error
)

REM ==== TAGESBACKUP ====
call :log "Tagesbackup erstellen..."
"%toolsdir%\drw2gbk.exe" /A /D"%backupdir%\" /F"%datum%-draegerware-tagesbackup.fbkx"
if errorlevel 1 (
    echo [FEHLER] Tagesbackup konnte nicht erstellt werden.
    call :log "[FEHLER] Tagesbackup konnte nicht erstellt werden."
    goto :error
)
call :log "Tagesbackup erfolgreich erstellt."

REM ==== LSCHEN ALTER TAGESBACKUPS ====
forfiles /P "%backupdir%" /S /M *-tagesbackup.fbkx /D %alter_tagesbackups% /C "cmd /c del @path"
if errorlevel 1 (
    echo [WARNUNG] Fehler beim Lschen alter Tagesbackups.
    call :log "[WARNUNG] Fehler beim Lschen alter Tagesbackups."
)

REM ==== PAUSE ====
timeout /T 5 /NOBREAK >NUL

REM ==== WOCHENBACKUP ====
if "%wochentag%"=="%backuptag%" (
    call :log "Wochenbackup erstellen..."
    copy /Y "%backupdir%\%datum%-draegerware-tagesbackup.fbkx" "%backupdir%\%datum%-draegerware-wochenbackup.fbkx"
    if errorlevel 1 (
        echo [FEHLER] Wochenbackup konnte nicht erstellt werden.
        call :log "[FEHLER] Wochenbackup konnte nicht erstellt werden."
        goto :error
    )
    call :log "Wochenbackup erfolgreich erstellt."

    forfiles /P "%backupdir%" /S /M *-wochenbackup.fbkx /D %alter_wochenbackups% /C "cmd /c del @path"
    if errorlevel 1 (
        echo [WARNUNG] Fehler beim Lschen alter Wochenbackups.
        call :log "[WARNUNG] Fehler beim Lschen alter Wochenbackups."
    )
)

REM ==== MONATSBACKUP ====
if "%tag_des_monats%"=="01" (
    call :log "Monatsbackup erstellen..."
    copy /Y "%backupdir%\%datum%-draegerware-tagesbackup.fbkx" "%backupdir%\%jahr%-%monat%-draegerware-monatsbackup.fbkx"
    if errorlevel 1 (
        echo [FEHLER] Monatsbackup konnte nicht erstellt werden.
        call :log "[FEHLER] Monatsbackup konnte nicht erstellt werden."
        goto :error
    )
    call :log "Monatsbackup erfolgreich erstellt."

    forfiles /P "%backupdir%" /S /M *-monatsbackup.fbkx /D %alter_monatsbackups% /C "cmd /c del @path"
    if errorlevel 1 (
        echo [WARNUNG] Fehler beim Lschen alter Monatsbackups.
        call :log "[WARNUNG] Fehler beim Lschen alter Monatsbackups."
    )
)

REM ==== JAHRESBACKUP ====
if "%monat%"=="01" if "%tag_des_monats%"=="01" (
    call :log "Jahresbackup erstellen..."
    copy /Y "%backupdir%\%datum%-draegerware-tagesbackup.fbkx" "%backupdir%\%jahr%-draegerware-jahresbackup.fbkx"
    if errorlevel 1 (
        echo [FEHLER] Jahresbackup konnte nicht erstellt werden.
        call :log "[FEHLER] Jahresbackup konnte nicht erstellt werden."
        goto :error
    )
    call :log "Jahresbackup erfolgreich erstellt."
)

call :log "Backup-Skript erfolgreich abgeschlossen."
echo.
echo Das Backup wurde erfolgreich durchgefhrt.
echo Das LOG wurde gespeichert unter: %logfile%
goto :eof

REM ==== FEHLERBEHANDLUNG ====
:error
call :log "Backup-Skript wurde wegen eines Fehlers abgebrochen."
echo.
echo [FEHLER] Das Backup-Skript wurde abgebrochen.
echo Das LOG wurde gespeichert unter: %logfile%
exit /b 1

REM ==== LOG-FUNKTION ====
:log
REM %1 = Logtext
setlocal enabledelayedexpansion
echo [%date% %time%] %~1 >> "%logfile%"
endlocal
goto :eof
